% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NativeStyleService.R
\name{dfp_getNativeStylesByStatement}
\alias{dfp_getNativeStylesByStatement}
\title{getNativeStylesByStatement}
\usage{
dfp_getNativeStylesByStatement(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getNativeStylesByStatementResponse
}
\description{
Gets a NativeStylePage NativeStylePage of NativeStyle objects that satisfy the given Statement. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{name}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getNativeStylesByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/NativeStyleService#getNativeStylesByStatement}{Google Documentation for getNativeStylesByStatement}
}
