% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserTeamAssociationService.R
\name{dfp_getUserTeamAssociationsByStatement}
\alias{dfp_getUserTeamAssociationsByStatement}
\title{getUserTeamAssociationsByStatement}
\usage{
dfp_getUserTeamAssociationsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getUserTeamAssociationsByStatementResponse
}
\description{
Gets a UserTeamAssociationPage of UserTeamAssociation objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{userId}
  \item{teamId}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getUserTeamAssociationsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/UserTeamAssociationService#getUserTeamAssociationsByStatement}{Google Documentation for getUserTeamAssociationsByStatement}
}
