context("WorkflowRequestService")

rdfp_options <- readRDS("rdfp_options.rds")
options(rdfp.network_code = rdfp_options$network_code)
options(rdfp.httr_oauth_cache = FALSE)
options(rdfp.application_name = rdfp_options$application_name)
options(rdfp.client_id = rdfp_options$client_id)
options(rdfp.client_secret = rdfp_options$client_secret)

dfp_auth(token = "rdfp_token.rds")

test_that("dfp_getWorkflowRequestsByStatement", {

   request_data <- list('filterStatement'=list('query'="WHERE type='WORKFLOW_APPROVAL_REQUEST'"))
   expect_error(dfp_getWorkflowRequestsByStatement(request_data), 'FeatureError.MISSING_FEATURE')
})

test_that("dfp_performWorkflowRequestAction", {
  
  options(rdfp.network_code = rdfp_options$test_network_code)
  request_data <- list(action='ApproveWorkflowApprovalRequests',
                       filterStatement=list('query'=paste0("WHERE type='WORKFLOW_APPROVAL_REQUEST'")))
  
  expect_error(dfp_performWorkflowRequestAction(request_data), 'FeatureError.MISSING_FEATURE')
  options(rdfp.network_code = rdfp_options$network_code)
})

