% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alexa_cat.R
\name{alexa_cat}
\alias{alexa_cat}
\title{Get Category from Alexa}
\usage{
alexa_cat(domain = NULL, key = NULL, secret = NULL)
}
\arguments{
\item{domain}{domain name}

\item{key}{Alexa Access Key ID}

\item{secret}{Alexa Secret Access Key}
}
\value{
data.frame with 2 columns Title and AbsolutePath
}
\description{
Get the Access Key ID and Secret Access Key by logging into \url{https://console.aws.amazon.com/},
clicking on the username followed by security credentials. Either pass the access key and secret or
set two environmental variables \code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY}.
These environment variables persist within a R session.
}
\examples{
\dontrun{
alexa_cat(domain = "http://www.google.com")
}
}
\references{
\url{https://docs.aws.amazon.com/AlexaWebInfoService/latest/}
}
