% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drop_read_csv.R
\name{drop_read_csv}
\alias{drop_read_csv}
\title{drop_read_csv}
\usage{
drop_read_csv(file, dest = tempdir(), dtoken = get_dropbox_token(), ...)
}
\arguments{
\item{file}{Name of file with full path relative to Dropbox root}

\item{dest}{A temporary directory where a csv file is downloaded before being read into memory}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}

\item{...}{Additional arguments into \code{read.csv}}
}
\description{
A lightweight wrapper around \code{read.csv} to read csv files from Dropbox into memory
}
\examples{
\dontrun{
write.csv(iris, file = "iris.csv")
drop_upload("iris.csv")
# Now let's read this back into an R session
new_iris <- drop_read_csv("iris.csv")
}
}

