% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearbyStations.R
\name{nearbyStations}
\alias{nearbyStations}
\title{Find DWD stations close to given coordinates}
\usage{
nearbyStations(lat, lon, radius, res = NA, var = NA, per = NA,
  mindate = NA, hasfileonly = TRUE,
  statname = "nearbyStations target location", quiet = FALSE, ...)
}
\arguments{
\item{lat, lon}{Coordinates [degrees N/S, E/W]}

\item{radius}{Maximum distance [km] within which stations will be selected}

\item{res, var, per}{Restrictions for dataset type as documented in
\code{\link{selectDWD}}. Each can be a vector of entries.
DEFAULTS: NA (ignored)}

\item{mindate}{Minimum dataset ending date (as per metadata).
Integer in the form of YYYYMMDD, e.g. 20170301. DEFAULT: NA}

\item{hasfileonly}{Logical: only return entries for which there is an
open-access file available? DEFAULT: TRUE}

\item{statname}{Character: name for target location. DEFAULT:
"nearbyStations target location"}

\item{quiet}{Logical: suppress progress messages? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{\link{selectDWD}}}
}
\value{
\code{\link{metaIndex}} subset with additional columns "dist" and "url"
}
\description{
Select DWD stations within a given radius around a set of coordinates
}
\examples{

m <- nearbyStations(49.211784, 9.812475, radius=30,
    res=c("daily","hourly"), var= c("precipitation","more_precip","kl") ,
    mindate=20160530, statname="Braunsbach catchment center")
# View(m)
    
# see the use cases vignette for a continued example of this:
vignette("cases")

}
\seealso{
\code{\link{selectDWD}}, \code{\link{metaIndex}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Mar 2017
}
