% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_scales.R
\name{color_scales}
\alias{color_scales}
\title{Add color scales to rows in a column}
\usage{
color_scales(data, colors = c("#ff3030", "#ffffff", "#1e90ff"))
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{colors}{A vector of colors to color the cells.
Colors should be given in order from low values to high values.
Default colors provided are red-white-blue: c("#ff3030", "#ffffff", "#1e90ff").
Can use R's built-in colors or other color packages.}
}
\value{
a function that applies conditional colors
    to a column of numeric values.
}
\description{
The `color_scales()` function conditionally colors each cell of a column depending on their value in relation to other values in that particular column.
    It should be placed within the style argument in reactable::colDef.
}
\examples{
data <- iris[10:29, ]

## By default, the colors_scales() function uses a red-white-blue three-color pattern
reactable(data,
 columns = list(
 Petal.Length = colDef(style = color_scales(data))))

## If only two colors are desired,
## you can specify them with colors = 'c(color1, color2)';

reactable(data,
 columns = list(
 Petal.Length = colDef(style = color_scales(data,
 colors = c("red", "green")))))

## Apply color_scales() across all numeric columns using reactable::defaultColDef
reactable(data,
defaultColDef = colDef(style = color_scales(data)))

}
