% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xmile.R
\name{read_xmile}
\alias{read_xmile}
\title{Read an XMILE file into R}
\usage{
read_xmile(filepath)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}
}
\value{
This function returns a list with three elements. The first element,
\emph{description}, is a list that contains the simulation parameters, and
the names and equations (including graphical functions) for each stock or
level, variable and constant. The second element, \emph{deSolve_components},
is a list that contains initial values, constants and the function for
simulating via deSolve. The third element, \emph{igraph} contains the
data.frames for creating a graph with igraph.
}
\description{
\code{read_xmile} returns a list for constructing deSolve functions and graphs
}
\details{
This function extracts the xml from the file specified via \code{filepath}
to generate a list of objects. Such a list contains a summary of the model,
the inputs for simulating through \link[deSolve]{deSolve}, and the inputs for
creating a \link[igraph]{igraph} object.
}
\examples{
path <- system.file("models", "SIR.stmx", package = "readsdr")
read_xmile(path)
}
