% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_functions.R
\name{geocode_st}
\alias{geocode_st}
\title{Generate geocoded and time-stamped data}
\usage{
geocode_st(df, api_key)
}
\arguments{
\item{df}{A data frame containing columns with the address (either "Address" or "address") and date (either "Date" or "date")
of the cases.}

\item{api_key}{A string. A valid Google Developers Geocode API key.}
}
\value{
A data frame with the columns for longitude, latitude, and time.
}
\description{
Use Google Maps API to produce longitude and latitude data
}
\details{
A wrapper to functions from package \code{googleway} that checks for errors and
fetches longitude and latitude coordinates using the Google Maps API. Dates are converted
to integer values with t=1 being the earliest date provided.
}
\examples{
\dontrun{
#requires working API to run
tmp <- data.frame(address=c("Buckingham palace","Big ben, Westminster","Marble arch, London"),
                  date = c("01/01/2020","02/01/2020","03/01/2020"))
geocode_st(tmp, api_key = "ENTER_KEY")
}
}
