library(realestateDK)
library(testthat)

context("Testing BM010")
test_data <- BM010(EJKAT20 = "1", OMR20 = "00", PRIS20 = "UDBUD", Tid = "1992K1")
expect_true(all(toupper(c('EJKAT20', 'OMR20', 'PRIS20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing BM011")
test_data <- BM011(EJKAT20 = "1", PNR20 = "1000", PRIS20 = "UDBUD", Tid = "1992K1")
expect_true(all(toupper(c('EJKAT20', 'PNR20', 'PRIS20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing BM020")
test_data <- BM020(BEV20 = "SALG", EJKAT20 = "1", OMR20 = "00", Tid = "2004K1")
expect_true(all(toupper(c('BEV20', 'EJKAT20', 'OMR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing BM021")
test_data <- BM021(BEV20 = "SALG", EJKAT20 = "1", PNR20 = "1000", Tid = "2004K1")
expect_true(all(toupper(c('BEV20', 'EJKAT20', 'PNR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing BM030")
test_data <- BM030(EJKAT20 = "1", OMR20 = "00", Tid = "2004K1")
expect_true(all(toupper(c('EJKAT20', 'OMR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing BM031")
test_data <- BM031(EJKAT20 = "1", PNR20 = "1000", Tid = "2004K1")
expect_true(all(toupper(c('EJKAT20', 'PNR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing UL10")
test_data <- UL10(DATATYP20 = "2", EJKAT20 = "11", LANTYP20 = "111", OMR20 = "A", Tid = "1995K1")
expect_true(all(toupper(c('DATATYP20', 'EJKAT20', 'LANTYP20', 'OMR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing UL30")
test_data <- UL30(AFDRAG = "0", EJKAT20 = "11", LANTYP20 = "111", OMR20 = "A", Tid = "2008K1")
expect_true(all(toupper(c('AFDRAG', 'EJKAT20', 'LANTYP20', 'OMR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing UDB010")
test_data <- UDB010(BOLA20 = "6", EJKAT20 = "1", OMR20 = "00", Tid = "2004M01")
expect_true(all(toupper(c('BOLA20', 'EJKAT20', 'OMR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing UDB020")
test_data <- UDB020(BOLB20 = "4", EJKAT20 = "1", OMR20 = "00", Tid = "2004M01")
expect_true(all(toupper(c('BOLB20', 'EJKAT20', 'OMR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)

context("Testing UDB030")
test_data <- UDB030(BOLC20 = "8", EJKAT20 = "1", OMR20 = "00", Tid = "2004M01")
expect_true(all(toupper(c('BOLC20', 'EJKAT20', 'OMR20', 'Tid')) %in% names(test_data)))
expect_true(ncol(test_data) > 0)
expect_true(nrow(test_data) > 0)
