% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_n_fn.R
\name{create_n_fn}
\alias{create_n_fn}
\title{Create n_fn function}
\usage{
create_n_fn(fn, use_index = FALSE, negate = FALSE, round_fn = round, ...)
}
\arguments{
\item{fn}{Function to apply to each dimension. Should return a numeric scalar.}

\item{use_index}{Whether to apply \code{`fn`} to the \emph{indices} of the vectors. (Logical)

The indices are created with \code{seq_along(x)}.}

\item{negate}{Whether to negate the result. I.e. to multiply it with \code{-1}. (Logical)}

\item{round_fn}{Function for rounding results of \code{`fn`}.

Rounding is done \emph{prior} to negation.

E.g. \code{\link[base:Round]{round}}, \code{\link[base:Round]{floor}}, or \code{\link[base:Round]{ceiling}}.

To avoid rounding, supply \code{\link[base:identity]{identity}}.}

\item{...}{Arguments for \code{`fn`}. E.g. \code{`na.rm = TRUE`}.}
}
\value{
Function with the dots (\code{`...`}) argument
that applies the \code{`fn`} function to
each element in \code{`...`} (or indices thereof) (usually one vector per dimension).
The results are rounded with \code{`round_fn`}.

Note: The dots argument in the generated function should not to be confused with the dots
argument in \code{create_n_fn()}).
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Creates a function that applies a supplied function to all
input vectors, or their indices, and rounds the results.

As used with \code{\link[rearrr:roll_elements]{roll_elements()}}. E.g. to
find the the median index in a subset of a grouped \code{data.frame}.
}
\examples{
# Attach packages
library(rearrr)

# Set seed
set.seed(1)

# Create three vectors
x <- runif(10)
y <- runif(10)
z <- runif(10)

# Create n_fn that gets the median index
# and rounds down with floor()
median_index_fn <- create_n_fn(median, use_index = TRUE, round_fn = floor)

# Use median_index_fn
median_index_fn(x, y, z)

# Create n_fn that gets the median of each dimension
median_n_fn <- create_n_fn(median)

# Use median_origin_fn
median_n_fn(x, y, z)

# Should be the same as
round(c(median(x), median(y), median(z)))

# Use mean and ignore missing values
mean_n_fn <- create_n_fn(mean, na.rm = TRUE)

# Add missing values
x[[2]] <- NA
y[[5]] <- NA

# Use mean_n_fn
mean_n_fn(x, y, z)

# Should be the same as
round(c(
  mean(x, na.rm = TRUE),
  mean(y, na.rm = TRUE),
  mean(z, na.rm = TRUE)
))
}
\seealso{
Other n functions: 
\code{\link{median_index}()}

Other function creators: 
\code{\link{create_dimming_fn}()},
\code{\link{create_origin_fn}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{function creators}
\concept{n functions}
