% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_at.R
\name{step_mutate_at}
\alias{step_mutate_at}
\title{Mutate multiple columns}
\usage{
step_mutate_at(
  recipe,
  ...,
  fn,
  role = "predictor",
  trained = FALSE,
  inputs = NULL,
  skip = FALSE,
  id = rand_id("mutate_at")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{fn}{A function fun, a quosure style lambda `~ fun(.)`` or a list of
either form. (see \code{\link[dplyr:mutate_all]{dplyr::mutate_at()}}). \strong{Note that this argument must be
named}.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the function assumes that the new dimension
columns created by the original variables will be used as predictors in a
model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{A vector of column names populated by \code{prep()}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} which contains the columns being transformed.
}
\description{
\code{step_mutate_at} creates a \emph{specification} of a recipe step that will modify
the selected variables using a common function.
}
\examples{
library(dplyr)
recipe(~ ., data = iris) \%>\%
  step_mutate_at(contains("Length"), fn = ~ 1/.) \%>\%
  prep() \%>\%
  juice() \%>\%
  slice(1:10)

recipe(~ ., data = iris) \%>\%
  # leads to more columns being created.
  step_mutate_at(contains("Length"), fn = list(log = log, sqrt = sqrt)) \%>\%
  prep() \%>\%
  juice() \%>\%
  slice(1:10)
}
\concept{preprocessing}
\concept{transformation_methods}
\keyword{datagen}
