% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy.R
\name{step_dummy}
\alias{step_dummy}
\alias{tidy.step_dummy}
\title{Dummy Variables Creation}
\usage{
step_dummy(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  one_hot = FALSE,
  preserve = deprecated(),
  naming = dummy_names,
  levels = NULL,
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("dummy")
)

\method{tidy}{step_dummy}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
\emph{factor} variables will be used to create the dummy variables. See
\code{\link[=selections]{selections()}} for more details. The selected
variables must be factors. For the \code{tidy()} method, these are
not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the binary dummy variable columns created by the original
variables will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{one_hot}{A logical. For C levels, should C dummy variables be created
rather than C-1?}

\item{preserve}{Use \code{keep_original_cols} to specify whether the selected
column(s) should be retained (in addition to the new dummy variables).}

\item{naming}{A function that defines the naming convention for
new dummy columns. See Details below.}

\item{levels}{A list that contains the information needed to
create dummy variables for each variable contained in
\code{terms}. This is \code{NULL} until the step is trained by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_dummy} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or original variables selected) and \code{columns} (the
list of corresponding binary columns).
}
\description{
\code{step_dummy()} creates a \emph{specification} of a recipe
step that will convert nominal data (e.g. character or factors)
into one or more numeric binary model terms for the levels of
the original data.
}
\details{
\code{step_dummy()} will create a set of binary dummy
variables from a factor variable. For example, if an unordered
factor column in the data set has levels of "red", "green",
"blue", the dummy variable bake will create two additional
columns of 0/1 data for two of those three values (and remove
the original column). For ordered factors, polynomial contrasts
are used to encode the numeric values.

By default, the excluded dummy variable (i.e. the reference
cell) will correspond to the first level of the unordered
factor being converted.

The function allows for non-standard naming of the resulting
variables. For an unordered factor named \code{x}, with levels \code{"a"}
and \code{"b"}, the default naming convention would be to create a
new variable called \code{x_b}. Note that if the factor levels are
not valid variable names (e.g. "some text with spaces"), it will
be changed by \code{\link[base:make.names]{base::make.names()}} to be valid (see the example
below). The naming format can be changed using the \code{naming}
argument and the function \code{\link[=dummy_names]{dummy_names()}} is the default. This
function will also change the names of ordinal dummy variables.
Instead of values such as "\code{.L}", "\code{.Q}", or "\verb{^4}", ordinal
dummy variables are given simple integer suffixes such as
"\verb{_1}", "\verb{_2}", etc.

To change the type of contrast being used, change the global
contrast option via \code{options}.

When the factor being converted has a missing value, all of the
corresponding dummy variables are also missing. See \code{\link[=step_unknown]{step_unknown()}} for
a solution.

When data to be processed contains novel levels (i.e., not
contained in the training set), a missing value is assigned to
the results. See \code{\link[=step_other]{step_other()}} for an alternative.

If no columns are selected (perhaps due to an earlier \code{step_zv()}),
\code{bake()} will return the data as-is (e.g. with no dummy variables).

Note that, by default, the new dummy variable column names obey the naming
rules for columns. If there are levels such as "0", \code{\link[=dummy_names]{dummy_names()}} will put
a leading "X" in front of the level (since it uses \code{\link[=make.names]{make.names()}}). This can
be changed by passing in a different function to the \code{naming} argument for
this step.

The \href{https://recipes.tidymodels.org/articles/Dummies.html}{package vignette for dummy variables}
and interactions has more information.
}
\examples{
library(modeldata)
data(okc)
okc <- okc[complete.cases(okc),]

# Original data: diet has 18 levels
length(unique(okc$diet))
unique(okc$diet) \%>\% sort()

rec <- recipe(~ diet + age + height, data = okc)

# Default dummy coding: 17 dummy variables
dummies <- rec \%>\%
    step_dummy(diet) \%>\%
    prep(training = okc)

dummy_data <- bake(dummies, new_data = NULL)

dummy_data \%>\%
    select(starts_with("diet")) \%>\%
    names() # level "anything" is the reference level

# Obtain the full set of 18 dummy variables using `one_hot` option
dummies_one_hot <- rec \%>\%
    step_dummy(diet, one_hot = TRUE) \%>\%
    prep(training = okc)

dummy_data_one_hot <- bake(dummies_one_hot, new_data = NULL)

dummy_data_one_hot \%>\%
    select(starts_with("diet")) \%>\%
    names() # no reference level


tidy(dummies, number = 1)
tidy(dummies_one_hot, number = 1)
}
\seealso{
\code{\link[=step_factor2string]{step_factor2string()}}, \code{\link[=step_string2factor]{step_string2factor()}},
\code{\link[=dummy_names]{dummy_names()}}, \code{\link[=step_regex]{step_regex()}}, \code{\link[=step_count]{step_count()}},
\code{\link[=step_ordinalscore]{step_ordinalscore()}}, \code{\link[=step_unorder]{step_unorder()}}, \code{\link[=step_other]{step_other()}}
\code{\link[=step_novel]{step_novel()}}
}
\concept{dummy_variables}
\concept{model_specification}
\concept{preprocessing}
\concept{variable_encodings}
\keyword{datagen}
