% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{juice}
\alias{juice}
\title{Extract Finalized Training Set}
\usage{
juice(object, ..., composition = "tibble")
}
\arguments{
\item{object}{A \code{recipe} object that has been prepared
with the option \code{retain = TRUE}.}

\item{...}{One or more selector functions to choose which variables will be
returned by the function. See \code{\link[=selections]{selections()}} for more details.
If no selectors are given, the default is to use
\code{\link[=everything]{everything()}}.}

\item{composition}{Either "tibble", "matrix", or "dgCMatrix" for the
format of the processed data set. Note that all computations
during the baking process are done in a non-sparse format. Also,
note that this argument should be called \strong{after} any selectors
and the selectors should only resolve to numeric columns
(otherwise an error is thrown).}
}
\description{
As steps are estimated by \code{prep}, these operations are
applied to the training set. Rather than running \code{bake}
to duplicate this processing, this function will return
variables from the processed training set.
}
\details{
When preparing a recipe, if the training data set is
retained using \code{retain = TRUE}, there is no need to \code{bake} the
recipe to get the preprocessed training set.

\code{juice} will return the results of a recipes where \emph{all steps}
have been applied to the data, irrespective of the value of
the step's \code{skip} argument.
}
\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

sp_signed <- rec \%>\%
  step_center(all_predictors()) \%>\%
  step_scale(all_predictors()) \%>\%
  step_spatialsign(all_predictors())

sp_signed_trained <- prep(sp_signed, training = biomass_tr, retain = TRUE)

tr_values <- bake(sp_signed_trained, newdata = biomass_tr, all_predictors())
og_values <- juice(sp_signed_trained, all_predictors())

all.equal(tr_values, og_values)
}
\seealso{
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}} \code{\link[=bake.recipe]{bake.recipe()}}
}
