% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag.R
\name{step_lag}
\alias{step_lag}
\title{Create a lagged predictor}
\usage{
step_lag(recipe, ..., role = "predictor", trained = FALSE, lag = 1,
  prefix = "lag_", default = NA, skip = FALSE)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Defaults to "predictor"}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{lag}{A vector of positive integers. Each specified column will be
lagged for each value in the vector.}

\item{prefix}{A prefix for generated column names, default to "lag_".}

\item{default}{Passed to \code{dplyr::lag}, determines what fills empty rows
left by lagging (defaults to NA).}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}
}
\value{
An updated version of \code{recipe} with the
new step added to the sequence of existing steps (if any).
}
\description{
\code{step_lag} creates a \emph{specification} of a recipe step that
will add new columns of lagged data. Lagged data will
by default include NA values where the lag was induced.
These can be removed with \code{\link[=step_naomit]{step_naomit()}}, or you may
specify an alternative filler value with the \code{default}
argument.
}
\details{
The step assumes that the data are already \emph{in the proper sequential
order} for lagging.
}
\examples{
n <- 10
start <- as.Date('1999/01/01')
end <- as.Date('1999/01/10')

df <- data.frame(x = runif(n),
                 index = 1:n,
                 day = seq(start, end, by = "day"))

recipe(~ ., data = df) \%>\%
  step_lag(index, day, lag = 2:3) \%>\%
  prep(df) \%>\%
  bake(df)

}
\seealso{
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}} \code{\link[=bake.recipe]{bake.recipe()}} \code{\link[=step_naomit]{step_naomit()}}
}
