#' @name constants
#' @title Constants for Use in the redcapAPI Package
#'
#' @description Constants that are used inside the package
#'

# The field names listed here are those generated by REDCap. 
# A listing of these fields was needed to support missingSummary.
# It wouldn't hurt to contemplate how these could be obtained 
# dynamically rather than relying up updating constants.

#' @export

REDCAP_SYSTEM_FIELDS <- c("redcap_event_name", 
                          "redcap_data_access_group", 
                          "redcap_repeat_instrument", 
                          "redcap_repeat_instance")


# UNEXPORTED --------------------------------------------------------

# These are variables in the Users table coded as 0 = No Access, 1 = Access
REDCAP_USER_TABLE_ACCESS_VARIABLES <- 
  c("design", 
    "user_rights", 
    "data_access_groups", 
    "reports", 
    "stats_and_charts", 
    "manage_survey_participants", 
    "calendar", 
    "data_import_tool", 
    "data_comparison_tool", 
    "logging", 
    "file_repository", 
    "data_quality_create", 
    "data_quality_execute", 
    "api_export", 
    "api_import", 
    "mobile_app", 
    "mobile_app_download_data", 
    "record_create", 
    "record_rename", 
    "record_delete", 
    "lock_records_all_forms", 
    "lock_records", 
    "lock_records_customization", 
    "mycap_participants", 
    "random_setup", 
    "random_dashboard", 
    "random_perform")
