% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_schwartz}
\alias{comp_schwartz}
\title{Calculate Schwartzberg Compactness}
\usage{
comp_schwartz(
  plans,
  shp,
  use_Rcpp,
  perim_path,
  perim_df,
  epsg = 3857,
  ncores = 1
)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{use_Rcpp}{Logical. Use Rcpp?}

\item{perim_path}{path to perimeter tibble saved by \code{prep_perims()}}

\item{perim_df}{tibble of perimeters from \code{prep_perims()}}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}

\item{ncores}{numeric. Number of cores to use. Default is 1.}
}
\value{
numeric vector
}
\description{
Calculate Schwartzberg Compactness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_schwartz(plans = nh$r_2020, shp = nh)

# Or many plans:
comp_schwartz(plans = nh_m[, 3:5], shp = nh)

}
\references{
Schwartzberg, Joseph E. 1966. Reapportionment, Gerrymanders, and the Notion
of Compactness. Minnesota Law Review. 1701.
}
\concept{compactness}
