% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AOO_functions.R
\name{getAOOSilent}
\alias{getAOOSilent}
\title{Alternate function for getting AOO (with custom grid)}
\usage{
getAOOSilent(input.data, grid, min.percent.rule = FALSE, percent = 1)
}
\arguments{
\item{input.data}{Object of an ecosystem or species distribution. Accepts either
raster or spatial points formats. Please use a CRS with units measured in
metres.}

\item{grid}{Custom grid to be used to calculate AOO. Usually the output of
\code{gridUncertainty}}

\item{min.percent.rule}{Logical. If \code{TRUE} one percent of the grid cell
must be occupied before it is counted in the AOO.}

\item{percent}{Numeric. The minimum percent to be applied as a threshold for
the \code{min.percent.rule}}
}
\value{
Value. The AOO calculated with the input distribution and grid.
}
\description{
\code{getAOOSilent} is identical to \code{getAOO}, but allows the custom
input of the grid parameter. Used for \code{gridUncertainty}.
}
\seealso{
Other AOO functions: \code{\link{createGrid}},
  \code{\link{getAOO}}, \code{\link{makeAOOGrid}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
\concept{AOO functions}
