\name{smooth.construct.pss.smooth.spec}
\alias{smooth.construct.pss.smooth.spec}
\title{P-spline constructor with modified 'shrinkage' penalty}
\usage{
  \method{smooth.construct}{pss.smooth.spec} (object, data,
    knots)
}
\arguments{
  \item{object}{see \code{\link[mgcv]{smooth.construct}}.
  The shrinkage factor can be speficied via
  \code{object$xt$shrink}}

  \item{data}{see \code{\link[mgcv]{smooth.construct}}.}

  \item{knots}{see \code{\link[mgcv]{smooth.construct}}.}
}
\description{
  Construct a B-spline basis with a modified difference
  penalty of full rank (i.e., that also penalizes low-order
  polynomials).
}
\details{
  This penalty-basis combination is useful to avoid
  non-identifiability issues for \code{\link{ff}} terms.
  See 'ts' or 'cs' in \code{\link[mgcv]{smooth.terms}} for
  similar "shrinkage penalties" for thin plate and cubic
  regression splines. The basic idea is to replace the k-th
  zero eigenvalue of the original penalty by \eqn{s^k
  \nu_m}, where \eqn{s} is the shrinkage factor (defaults
  to 0.1) and \eqn{\nu_m} is the smallest non-zero
  eigenvalue. See reference for the original idea,
  implentation follows that in the 'ts' and 'cs'
  constructors.
}
\author{
  Fabian Scheipl; adapted from 'ts' and 'cs' constructors
  by S.N. Wood.
}
\references{
  Marra, G., & Wood, S. N. (2011). Practical variable
  selection for generalized additive models.
  \emph{Computational Statistics & Data Analysis}, 55(7),
  2372-2387.
}

