% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cv_regsem.R
\name{cv_regsem}
\alias{cv_regsem}
\title{The main function that ties together and runs the models.}
\usage{
cv_regsem(model, n.lambda = 100, mult.start = TRUE, multi.iter = 100,
  jump = 0.002, type = "none", fit.ret = c("rmsea", "BIC"),
  fit.ret2 = c("train", "test"), data = NULL, optMethod = "nlminb",
  gradFun = "ram", hessFun = "none", parallel = "no", Start = "default",
  subOpt = "nlminb", longMod = F, optNL = "NLOPT_LN_NEWUOA_BOUND",
  fac.type = "cfa", matrices = "extractMatrices", pars_pen = NULL,
  diff_par = NULL, LB = -Inf, UB = Inf, calc = "normal", tol = 1e-10,
  max.iter = 50000, missing = "listwise", ...)
}
\arguments{
\item{model}{lavaan output object.}

\item{n.lambda}{number of penalization values to test.}

\item{mult.start}{Logical. Whether to use multi_optim() (TRUE) or
regsem() (FALSE).}

\item{multi.iter}{number of random starts for multi_optim}

\item{jump}{Amount to increase penalization each iteration.}

\item{type}{penalty type.}

\item{fit.ret}{Fit indices to return.}

\item{fit.ret2}{Return fits from just train sample?}

\item{data}{Optional dataframe. Only required for missing="fiml".}

\item{optMethod}{solver to use.}

\item{gradFun}{gradient function to use.}

\item{hessFun}{hessian function to use.}

\item{parallel}{whether to parallelize the processes?}

\item{Start}{type of starting values to use.}

\item{subOpt}{type of optimization to use in the optimx package.}

\item{longMod}{longitudinal model?}

\item{optNL}{type of optimization to use in the NLopt package.}

\item{fac.type}{using cfa or efa type of model.}

\item{matrices}{function to use for extracting RAM matrices.}

\item{pars_pen}{parameter indicators to penalize.}

\item{diff_par}{parameter values to deviate from.}

\item{LB}{lower bound vector.}

\item{UB}{upper bound vector}

\item{calc}{type of calc function to use with means or not.}

\item{tol}{absolute tolerance for convergence.}

\item{max.iter}{max iterations for optimization.}

\item{missing}{How to handle missing data. Current options are "listwise"
and "fiml".}

\item{...}{Any additional arguments to pass to regsem() or multi_optim().}
}
\description{
The main function that ties together and runs the models.
}
\examples{
\dontrun{
library(lavaan)
HS <- data.frame(scale(HolzingerSwineford1939[,7:15]))
mod <- '
f =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9
'
outt = cfa(mod,HS)

cv.out = cv_regsem(outt,type="ridge",gradFun="none",n.lambda=100)
}
}
\keyword{calc}
\keyword{optim}

