% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_discrete.R
\name{plot_weighting_discrete}
\alias{plot_weighting_discrete}
\title{Plot weights subdivided by a discrete covariate}
\usage{
plot_weighting_discrete(mod, covariate, alpha = 0.05, ...)
}
\arguments{
\item{mod}{Weighting model object}

\item{covariate}{Covariate vector}

\item{alpha}{Number between zero and one indicating the desired alpha level
for confidence intervals.}

\item{...}{unused arguments}
}
\value{
A \code{ggplot2::ggplot} object.
}
\description{
This provides a simple plot for the distribution of a single
discrete covariate in the nominal sample and the implicit sample
defined by the Aronow and Samii (2015) \doi{10.1111/ajps.12185}
regression weights.
}
\examples{
y <- rnorm(100)
a <- rbinom(100, 1, 0.5)
x <- rnorm(100)
g <- sample(1:4, 100, replace = TRUE)
mod <- stats::lm(y ~ a + x)
rw_mod <- calculate_weights(mod, "a")
plot_weighting_discrete(rw_mod, g)
}
