% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.newick.R
\name{as.newick}
\alias{as.newick}
\title{Convert a furcation tree into Newick format}
\usage{
as.newick(furcation, allele = 0, side,
  hap.names = seq_len(furcation@nhap))
}
\arguments{
\item{furcation}{an object of \code{\link{furcation-class}}.}

\item{allele}{the allele to be considered (default 0).}

\item{side}{side (either \code{"left"} or \code{"right"}).}

\item{hap.names}{names/labels of chromosomes in haplotype data file. Per default
haplotypes are numbered by their order in the input file.}
}
\description{
Convert a furcation tree into Newick format.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#calculate furcation for the marker "F1205400"
#which displays a strong signal of selection
f <- calc_furcation(haplohh_cgu_bta12, mrk = "F1205400")
#get left tree of ancestral allele (coded as '0')
as.newick(f, 0, "left")
}
\seealso{
\code{\link{ftree-class}}, \code{\link{calc_furcation}}, \code{\link{plot.furcation}}
}
