% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFrequenciesFile.R
\name{checkFrequenciesFile}
\alias{checkFrequenciesFile}
\title{Load and check a frequency file}
\usage{
checkFrequenciesFile(filename, mix)
}
\arguments{
\item{filename}{Path of the frecuency database file}

\item{mix}{Data frame with mixture data. See relMix vignette for description of the format}
}
\value{
A list containing
\itemize{
\item {\code{df}} {Data frame with frequencies}
\item {\code{warning}} {List of strings describing the errors that ocurred but could be fixed or that do not prevent
the execution of the program.}
\item {\code{error}} {List of strings describing the errors that ocurred that made it imposible to return a valid data frame.
If this list is not empty, then the dataframe item will be NULL}}
}
\description{
Loads a frequency database file and compares it against mixture data to check for common errors.
}
\details{
The mixture data is used to perform more advanced checks, such as to make sure all alleles present
in the mixture file have an entry in the frequency database.
If warnings are found, the function attempts to fix them and explains what it has done in the warning messages.
If an error is found, checking stops and a NULL dataframe is returned. The error is described in the error messages.
}
\examples{
\dontrun{
mixfile <- system.file("extdata","mixture.txt",package="relMix")
mix <- checkMixtureFile(mixfile)
# note: the mixture dataframe is passed as an argument
# if the previous check failed, the program should not continue
# with the frequencies file check
freqfile <- system.file('extdata','frequencies22Markers.txt',package='relMix')
freqs <- checkFrequenciesFile(freqfile, mix$df)
}
}
\seealso{
\code{\link{checkMixtureFile}} for information on how to load a mixture file.
}
\author{
Elias Hernandis
}
