% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writePop.R
\name{writePop}
\alias{writePop}
\title{Saves/writes population profiles to disk}
\usage{
writePop(fileName, pop, addAmelo = FALSE, delim = ",",
  dupLoci = TRUE)
}
\arguments{
\item{fileName}{the name and path where the population profiles are to be
saved to.}

\item{pop}{an object of class \code{population}, most likely produced by
\code{breedFst}}

\item{addAmelo}{The simulated populations do not have Amelogenin. If
\code{TRUE} then an Amelogenin marker is added to the population, and all
the profiles are set to male XY, although this is coded to 1,2 to keep the
allele designations numeric.}

\item{delim}{The allele delimiter.}

\item{dupLoci}{If \code{TRUE} the locus names are written twice in the header, otherwise just once.}
}
\description{
Writes a population of profiles to disk using the original allele
designations rather than the internal integer representations that are used
for the other functions.
}
\note{
Rare alleles are recoded to 108.1.
}
\examples{

data(USCaucs)
pop = breedFst(USCaucs)
\dontrun{
  writePop("USCaucs.csv", pop)
  }
}
\seealso{
breedFst
}
\author{
James M. Curran
}
