% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-github.R
\name{parse_github_repo_spec}
\alias{parse_github_repo_spec}
\title{Parse a concise GitHub repo specification}
\usage{
parse_github_repo_spec(repo)
}
\arguments{
\item{repo}{Character scalar, the repo specification.}
}
\value{
List with members: \code{username}, \code{repo}, \code{subdir}
  \code{ref}, \code{pull}, \code{release}. Members that do not
  appear in the input repo specification are omitted.
}
\description{
The current format is:
\code{[username/]repo[/subdir][#pull|@ref|@*release]}
The \code{*release} suffix represents the latest release.
}
\examples{
parse_github_repo_spec("metacran/crandb")
parse_github_repo_spec("jeroenooms/curl@v0.9.3")
parse_github_repo_spec("jimhester/covr#47")
parse_github_repo_spec("hadley/dplyr@*release")
parse_github_repo_spec("mangothecat/remotes@550a3c7d3f9e1493a2ba")
}

