% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmsupport_modeleffectsizes.R
\name{lmSupport_modelEffectSizes}
\alias{lmSupport_modelEffectSizes}
\title{Get effect sizes (lmSupport::modelEffectSizes)}
\usage{
lmSupport_modelEffectSizes(Model, Print = TRUE, Digits = 4)
}
\arguments{
\item{Model}{a linear model, produced by lm}

\item{Print}{Display results to screen. Default = TRUE}

\item{Digits}{Number of digits for printing effect sizes}
}
\value{
Returns a list with fields for effect sizes, SSE, and SST.
}
\description{
Get effect sizes from the \code{lmSupport} package
and \code{modelEffectSizes} function. The function had to be taken
separately from the package as the package was removed from
CRAN and the dependency was failing.

From the original documentation: "Calculates unique SSRs, SSE,
SST. Based on these SSs, it calculates partial eta2 and delta
R2 for all effects in a linear model object. For categorical
variables coded as factors, it calculates these for multi-df
effect. Manually code regressors to get 1 df effects Uses
car::Anova() with Type 3 error"
}
\examples{
\donttest{
m <- lm(mpg ~ cyl + disp, data = mtcars)
lmSupport_modelEffectSizes(m)
}

}
\author{
John J. Curtin, \email{jjcurtin@wisc.edu}
}
\keyword{effect}
\keyword{interaction}
\keyword{internal}
\keyword{moderation}
\keyword{regression}
\keyword{size}
