% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_assumptions.R
\name{nice_assumptions}
\alias{nice_assumptions}
\title{Easy assumptions checks}
\usage{
nice_assumptions(model)
}
\arguments{
\item{model}{The \code{lm} object to be passed to the function.}
}
\value{
A dataframe, with p-value results for the Shapiro-Wilk,
Breusch-Pagan, and Durbin-Watson tests, as well as a
diagnostic column reporting how many assumptions are
not respected for a given model.
}
\description{
Test linear regression assumptions easily with a
nice summary table.
}
\examples{
# Create a regression model (using data available in R by default)
model <- lm(mpg ~ wt * cyl + gear, data = mtcars)
nice_assumptions(model)

# Multiple dependent variables at once
DV <- names(mtcars[-1])
formulas <- paste(DV, "~ mpg")
models.list <- lapply(X = formulas, FUN = lm, data = mtcars)
assumptions.table <- do.call("rbind", lapply(models.list, nice_assumptions
))
assumptions.table

}
\seealso{
Other functions useful in assumption testing:
\code{\link{nice_density}}, \code{\link{nice_normality}},
\code{\link{nice_qq}}, \code{\link{nice_varplot}},
\code{\link{nice_var}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/assumptions}
}
\keyword{assumptions}
\keyword{linear}
\keyword{regression}
\keyword{statistical}
\keyword{violations}
