% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{FEtype}
\alias{FEtype}
\title{FEtype}
\usage{
FEtype()
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for fixed effects for event types in the
tie-oriented model.
}
\details{
Fixed effects for event types capture the variation in event rate across
different event types (e.g., see Butts, 2008). The specification of FEtype
results in the creation of C-1 statistics, were C is the number of different
event types in the riskset. Let one of the event types, e.g. \emph{c = 1},
represent the reference category. Than, for every event type
\emph{c = 2, ..., C}, a statistic is created that at timepoint \emph{t} for
dyad \emph{(i,j,c)} is equal to 1 if \emph{c} is equal to the respective
event type and equal to 0 otherwise (i.e., dummy variables are created).
Note that specifying fixed effects for event types is only available when
event types are modeled in the dependent variable.
}
\examples{
history$type <- history$setting
reh_tie <- remify::remify(history, model = "tie")
effects <- ~ FEtype()
remstats(reh = reh_tie, tie_effects = effects)

}
\seealso{
\code{\link{event}}
}
