% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/entrez_search.r
\name{entrez_search}
\alias{entrez_search}
\title{Search the NCBI databases using EUtils}
\usage{
entrez_search(db, term, config = NULL, retmode = "xml", ...)
}
\arguments{
\item{db}{character Name of the database to search for}

\item{term}{character The search term}

\item{config}{vector configuration options passed to httr::GET}

\item{retmode}{character One of json (default) or xml. This will make no
difference in most cases.}

\item{\dots}{character Additional terms to add to the request}
}
\value{
ids integer Unique IDS returned by the search

count integer Total number of hits for the search

retmax integer Maximum number of hits returned by the search

QueryKey integer identifier for specific query in webhistory

WebEnv character identifier for session key to use with history

file either and XMLInternalDocument xml file resulting from search, parsed with
\code{\link[XML]{xmlTreeParse}} or, if \code{retmode} was set to json a list
resulting from the returned JSON file being parsed with
\code{\link[jsonlite]{fromJSON}}.
}
\description{
Constructs a query with the given arguments, including a search term, and
a database name, then retrieves the XML document created by that query.
}
\examples{
\dontrun{
   query <- "Gastropoda[Organism] AND COI[Gene]"
   web_env_search <- entrez_search(db="nuccore", query, usehistory="y")
   cookie <- web_env_search$WebEnv
   qk <- web_env_search$QueryKey
   snail_coi <- entrez_fetch(db = "nuccore", WebEnv = cookie, query_key = qk,
                             file_format = "fasta", retmax = 10)
}
\donttest{

fly_id <- entrez_search(db="taxonomy", term="Drosophila")
#Oh, right. There is a genus and a subgenus name Drosophila...
#how can we limit this seach
(tax_fields <- entrez_db_searchable("taxonomy"))
#"RANK" loots promising
tax_fields$RANK
entrez_search(db="taxonomy", term="Drosophila & Genus[RANK]")
}
}
\seealso{
\code{\link[httr]{config}} for available configs

\code{\link{entrez_db_searchable}} to get a set of search fields that
can be userd in \code{term} for any base
}

