% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivbinom.r
\name{biv.binom}
\alias{biv.binom}
\title{Marginal Bivariate Binomial Regression Models}
\usage{
biv.binom(freq, marg1 = ~1, marg2 = ~1, interaction = ~1,
  pmarg1 = 1, pmarg2 = 1, pinteraction = 1, print.level = 0,
  typsize = abs(p), ndigit = 10, gradtol = 1e-05, stepmax = 10 *
  sqrt(p \%*\% p), steptol = 1e-05, iterlim = 100, fscale = 1)
}
\arguments{
\item{freq}{A four-column matrix containing K 2x2 frequency tables.}

\item{marg1}{The model formula for the first margin.}

\item{marg2}{The model formula for the second margin.}

\item{interaction}{The model formula for the interaction.}

\item{pmarg1}{Initial parameter estimates for the first margin regression.}

\item{pmarg2}{Initial parameter estimates for the second margin regression.}

\item{pinteraction}{Initial parameter estimates for the interaction
regression.}

\item{print.level}{Arguments for nlm.}

\item{typsize}{Arguments for nlm.}

\item{ndigit}{Arguments for nlm.}

\item{gradtol}{Arguments for nlm.}

\item{stepmax}{Arguments for nlm.}

\item{steptol}{Arguments for nlm.}

\item{iterlim}{Arguments for nlm.}

\item{fscale}{Arguments for nlm.}
}
\value{
A list of class \code{bivbinom} is returned.
}
\description{
\code{biv.binom} fits (logit) linear regression models to a marginal
bivariate binomial distribution. The covariates must be of length K, that
is the number of 2x2 tables.
}
\examples{

# 5 2x2 tables
Freq <- matrix(rpois(20,10),ncol=4)
x <- c(6,8,10,12,14)
print(z <- biv.binom(Freq,marg1=~x,marg2=~x,inter=~x,pmarg1=c(-2,0.08),
	pmarg2=c(-2,0.1),pinter=c(3,0)))

}
\author{
J.K. Lindsey
}
\keyword{models}
