% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanFunctions.R
\name{ri.m.demo}
\alias{ri.m.demo}
\title{Simulation to demonstrate the meaning of the replication interval for the mean}
\usage{
ri.m.demo(n = 10, rep.n = NA, mu = 0, sigma = 1,
  number.trials = 10000, prob.level = 0.95, show.all.trials = FALSE)
}
\arguments{
\item{n}{Original study: Sample size}

\item{rep.n}{(optional) Replication study: Sample size. If not specified, n is used.}

\item{mu}{All samples are drawn from a common population. This specifies the population correlation.}

\item{sigma}{All samples are drawn from a common population. This specifies the population standard deviation.}

\item{number.trials}{Indicate the number of pairs of sample (original, replication) that should be used. 10,000 or higher suggested for stable results.}

\item{prob.level}{(optional 0 to 1 value) Probability level desired (0 to 1). If not specified .95 (i.e., 95 percent) will be used.}

\item{show.all.trials}{Show original correlation, replication interval, replication correlation, and whether replication effect is in the interval.}
}
\value{
The replication interval and related statistics in list format.
}
\description{
Simulation to demonstrate the meaning of the replication interval for the mean
}
\examples{
ri.m.demo(n=150,mu=0,sigma=1,number.trials=10)
}

