% Generated by roxygen2 (4.0.1): do not edit by hand
\name{source_data}
\alias{source_data}
\title{Load plain-text data and RData from a URL (either http or https)}
\source{
Originally based on source_url from the Hadley Wickham's devtools
package.
}
\usage{
source_data(url, rdata, sha1 = NULL, cache = FALSE, clearCache = FALSE,
  sep = ",", header = TRUE, stringsAsFactors = default.stringsAsFactors(),
  envir = parent.frame(), ...)
}
\arguments{
\item{url}{The data's URL. To distinguish between plain-text and RDATA the
\code{url} must end in a distinguishing file extension.}

\item{rdata}{logical. Whether or not the data set is an \code{.RDATA} file.
If not specified than \code{source_url} will attempt to determine whether or
not the file is an \code{.RDATA} file from the URL's extension.}

\item{sha1}{Character string of the file's SHA-1 hash, generated by
\code{source_data}. Note if you are using data stored using Git, this is not
the file's commit SHA-1 hash.}

\item{cache}{logical. Whether or not to cache the data so that it is not
downloaded every time the function is called.}

\item{clearCache}{logical. Whether or not to clear the downloaded data from
the cache.}

\item{sep}{The separator method for the plain-text data. For example, to load
comma-separated values data (CSV) use \code{sep = ","} (the default). To load
tab-separated values data (TSV) use \code{sep = "\t"}. Only relevant for
plain-text data.}

\item{header}{Logical, whether or not the first line of the file is the
header (i.e. variable names). The default is \code{header = TRUE}. Only
relevant for plain-text data.}

\item{stringsAsFactors}{logical. Should character vectors be converted to
factors? Note that this is overridden by \code{as.is} and \code{colClasses},
both of which allow finer control. Only relevant for plain-text data.}

\item{envir}{the environment where the data should be loaded.}

\item{...}{additional arguments passed to \code{\link{read.table}} or
\code{\link{load}} as relevant.}
}
\value{
a data frame
}
\description{
\code{source_data} loads plain-text or RDATA formatted data stored at a URL
(both http and https) into R.
}
\details{
Loads plain-text data (e.g. CSV, TSV) or RDATA from a URL. Works with
both HTTP and HTTPS sites. Note: the URL you give for the \code{url} argument
must be for the RAW version of the file. The function should work to download
plain-text data from any secure URL (https), though I have not verified this.

From the \code{source_url} documentation: "If a SHA-1 hash is specified with
the \code{sha1} argument, then this function will check the SHA-1 hash of the
downloaded file to make sure it matches the expected value, and throw an error
if it does not match. If the SHA-1 hash is not specified, it will print a
message displaying the hash of the downloaded file. The purpose of this is to
 improve security when running remotely-hosted code; if you have a hash of
the file, you can be sure that it has not changed."
}
\examples{
\dontrun{
# Download electoral disproportionality data stored on GitHub
# Note: Using shortened URL created by bitly
DisData <- source_data("http://bit.ly/156oQ7a")

# Check to see if SHA-1 hash matches downloaded file
DisDataHash <- source_data("http://bit.ly/Ss6zDO",
   sha1 = "dc8110d6dff32f682bd2f2fdbacb89e37b94f95d")
}
}
\seealso{
\link{httr}, \code{\link{read.table}}, and \code{\link{load}}
}

