% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/source_DropboxData.R
\name{source_DropboxData}
\alias{source_DropboxData}
\title{Load plain-text data from Dropbox non-Public folders}
\source{
Based on \code{source_url} from the Hadley Wickham's devtools package
and \code{url_dl} from the qdap package.
Data from: Gandrud, Christopher. 2013. "The Diffusion of Financial
Supervisory Governance Ideas." Review of International Political Economy.
20(4):881-916
}
\usage{
source_DropboxData(file, key, sha1 = NULL, cache = FALSE,
  clearCache = FALSE, sep = "auto", header = "auto", ...)
}
\arguments{
\item{file}{The plain-text formatted data's file name as a character string.}

\item{key}{The file's Dropbox key as a character string.}

\item{sha1}{Character string of the file's SHA-1 hash, generated by
\code{source_data}.}

\item{cache}{logical. Whether or not to cache the data so that it is not
downloaded every time the function is called.}

\item{clearCache}{logical. Whether or not to clear the downloaded data from
the cache.}

\item{sep}{The separator method for the data. For example, to load
comma-separated values data (CSV) use \code{sep = ","}. To load
tab-separated values data (TSV) use \code{sep = "\t"}.}

\item{header}{Logical, whether or not the first line of the file is the
header (i.e. variable names).}

\item{...}{additional arguments passed to \code{\link{fread}}.}
}
\value{
a data frame
}
\description{
\code{source_DropboxData} loads plain-text formatted data stored on Dropbox
in a non-Public folder.
}
\details{
Loads plain-text data (e.g. CSV, TSV) data from a Dropbox non-public
folder. To download data from a Drobpox Public folder simply use
\code{read.table}, giving the public URL as the file name.

To download data using \code{source_DropboxData} you will need (a) the file's
name and (b) its Dropbox key. The key can be found by clicking "Share Link".
The key will then be listed as part of the URL directly after
"https://www.dropbox.com/s/" and before the file name.

From the source_url documentation: "If a SHA-1 hash is specified with the
sha1 argument, then this function will check the SHA-1 hash of the downloaded
file to make sure it matches the expected value, and throw an error if it
does not match. If the SHA-1 hash is not specified, it will print a message
displaying the hash of the downloaded file. The purpose of this is to improve
security when running remotely-hosted code; if you have a hash of the file,
you can be sure that it has not changed."
}
\examples{
# Download Financial Regulatory Governance data (see Gandrud 2012)
FinData <- source_DropboxData(file = "fin_research_note.csv",
                              key = "exh4iobbm2p5p1v",
                              sep = ",", header = TRUE)
}
\seealso{
\link{httr} and \code{\link{fread}}
}

