% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_lazydo}
\alias{repo_lazydo}
\title{Run expression with cache.}
\usage{
repo_lazydo(rp, expr, force = F, env = parent.frame())
}
\arguments{
\item{rp}{An object of class repo.}

\item{expr}{An object of class exrepssion (the code to run).}

\item{force}{If TRUE, execute expr anyway}

\item{env}{Environment for expr, defaults to parent.}
}
\value{
Results of the expression (either loaded or computed on the
    fly).
}
\description{
lazydo searches the repo for previous execution of an
expression. If a previous execution is found, the result is loaded
and returned. Otherwise, the expression is executed and the result
stashed.
}
\details{
The expression results are stashed as usual. The name of
the resource is obtained by digesting the expression, so it will
look like an MD5 string in the repo. Note that the expression, and
not its result, will uniquely identify the item in the repo.

The new item is automatically tagged with "stash", "hide" and
"lazydo".
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
expr <- expression(
    {
        v <- vector("numeric", 10)
        for(i in 1:10) {
            v[i] <- i
            Sys.sleep(1/10)
        }
        print("Done.")
        v
    }
)

system.time(v <- rp$lazydo(expr)) # first run
## Repo needs to build resource.
## [1] "Done."
##    user  system elapsed 
##   0.006   0.000   1.007

system.time(v <- rp$lazydo(expr)) # second run
## Repo found precomputed resource.
##    user  system elapsed 
##   0.000   0.004   0.001

## The item's name in the repo can be obtained using digest:
library(digest)
resname <- digest(expr)
## Or as the name of the last item added:
resname <- tail(rp$entries(),1)[[1]]$name

rp$rm(resname) ## single cached item cleared

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
repo_stash, repo_put
}

