% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.character.R, R/report.data.frame.R,
%   R/report.factor.R, R/report.numeric.R
\name{report.character}
\alias{report.character}
\alias{report.data.frame}
\alias{report.factor}
\alias{report.numeric}
\title{Reporting Datasets and Dataframes}
\usage{
\method{report}{character}(
  x,
  n_entries = 3,
  levels_percentage = "auto",
  missing_percentage = "auto",
  ...
)

\method{report}{data.frame}(
  x,
  n = FALSE,
  centrality = "mean",
  dispersion = TRUE,
  range = TRUE,
  distribution = FALSE,
  levels_percentage = "auto",
  digits = 2,
  n_entries = 3,
  missing_percentage = "auto",
  ...
)

\method{report}{factor}(x, levels_percentage = "auto", ...)

\method{report}{numeric}(
  x,
  n = FALSE,
  centrality = "mean",
  dispersion = TRUE,
  range = TRUE,
  distribution = FALSE,
  missing_percentage = "auto",
  digits = 2,
  ...
)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{n_entries}{Number of different character entries to show. Can be "all".}

\item{levels_percentage}{Show characters entries and factor levels by number
or percentage. If "auto", then will be set to number and percentage if the
length if n observations larger than 100.}

\item{missing_percentage}{Show missing by number (default) or percentage. If
"auto", then will be set to number and percentage if the length if n
observations larger than 100.}

\item{...}{Arguments passed to or from other methods.}

\item{n}{Include number of observations for each individual variable.}

\item{centrality}{Character vector, indicating the index of centrality
(either \code{"mean"} or \code{"median"}).}

\item{dispersion}{Show index of dispersion (\link{sd} if \code{centrality = "mean"}, or \link{mad} if \code{centrality = "median"}).}

\item{range}{Show range.}

\item{distribution}{Show \code{\link[parameters:skewness]{kurtosis}} and \code{\link[parameters:skewness]{skewness}}.}

\item{digits}{Number of significant digits.}
}
\value{
An object of class \code{\link{report}}.
}
\description{
Create reports for data frames.
}
\examples{
library(report)

r <- report(iris,
  centrality = "median", dispersion = FALSE,
  distribution = TRUE, missing_percentage = TRUE
)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))

if (require("dplyr")) {
  r <- iris \%>\%
    dplyr::group_by(Species) \%>\%
    report()
  r
  summary(r)
  as.data.frame(r)
  summary(as.data.frame(r))
}
}
