% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MadeyskiKitchenhamMetaAnalysis.R
\name{getTheoreticalEffectSizeVariancesABBA}
\alias{getTheoreticalEffectSizeVariancesABBA}
\title{getTheoreticalEffectSizeVariancesABBA}
\usage{
getTheoreticalEffectSizeVariancesABBA(
  theoreticalvarW,
  theoreticalTechniqueEffect,
  theoreticalrho,
  N1,
  N2
)
}
\arguments{
\item{theoreticalvarW}{- The within subject variance used to construct the simulation, i.e., the built-in Variance - the built-in Covariance}

\item{theoreticalTechniqueEffect}{- The technique effect built into the crossover model data}

\item{theoreticalrho}{- The between subject correlation built into the crossover model simulation data}

\item{N1}{- The number of subjects in sequence group 1 in the crossover model simulation}

\item{N2}{- The number of subjects in sequence group 2 in the crossover model simulation}
}
\value{
data frame incl. calculated:
theoreticalt - the theoretical value of the t-statistic
theoreticalvart - variance of t
theoreticalvardIG -  variance of the effect size dIG based on the parameters built into crossover model data simulated by the getSimilationData function
theoreticalvardRM -  variance of the effect size dRM based on the parameters built into crossover model data simulated by the getSimilationData function
}
\description{
Function provides the theoretical value of the t-statistic, variance of t, and variance of the effect sizes based on the parameters built into crossover model data simulated by the getSimilationData() function.
Function is used in a paper "Effect Sizes and their Variance for AB/BA Crossover Design Studies" by Lech Madeyski and Barbara Kitchenham.
}
\examples{
# Generates data used in Table 15 of the paper
theoreticalEffectSizeVariances <- getTheoreticalEffectSizeVariancesABBA(6.25,-10,0.75,15,15)
}
\author{
Lech Madeyski and Barbara Kitchenham
}
