% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM data illustrate correlations
between results from individual participants in a family of four cross-over experiments
conducted by Scanniello et al:
[1] G.  Scanniello,  C. Gravino,  M. Genero, J.A. Cruz-Lemus, and  G. Tortora,  "On the Impact
of UML Analysis Models on Source-Code Comprehensibility and Modifiability", ACM Transactions on
Software Engineering and Methodlogy, vol. 23, no. 2, pp. 13:1-13:26, 2014
The family of experiments investigated whether the availability of analysis models in addition
to the source code made the code easier to understand and modify.
If you use this data set please cite:
[1] G.  G.  Scanniello,  C. Gravino,  M. Genero, J.A. Cruz-Lemus, and  G. Tortora, "On the
Impact of UML Analysis Models on Source-Code Comprehensibility and Modifiability", ACM
Transactions on Software Engineering and Methodology, vol. 23, no. 2, pp. 13:1-13:26, 2014
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).}
\format{
`KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM`: a data frame with 172
rows and 9 variables:
\describe{
\item{ExperimentID}{<fct> | ExperimentID: A unique identifier for each experiment in the data
set.}
\item{ParticipantID}{<fct> | Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{Treatment}{<fct> | Experimental Treatment: AM an Analysis Model with source code (AM) vs
Source Code only (SC)}
\item{SequenceGroup}{<fct> | Experimental Sequence Group: A (AM-SC,S1-S2), B (SC-AM,S1-S2),
C(AM-SC,S2-S1), D(SC-AM,S2-S1)}
\item{System}{<fct> | Software systems used in the experiment: S1 A system to sell and manage
CDs/DVDs in a music shop, S2 A system to book and by theater tickets.}
\item{Comprehension}{<dbl> | Dependent variable: The comprehension level the software engineer
achieved based on the F-measure }
\item{Modification}{<dbl> | Dependent variable: The modifiability level the software engineer
achieved based on the F-measure}
\item{Period}{<fct> | Time period of the cross-over experiment: 1 or 2}
\item{CrossOverID}{<fct> | CrossOver category: For 4 group the crossover category specifies the
matching pairs of sequence groups, CO1 and CO2. For 2 group crossover, the category is set to
CO1 only}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM
}
\description{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM data illustrate correlations
between results from individual participants in a family of four cross-over experiments
conducted by Scanniello et al:
[1] G.  Scanniello,  C. Gravino,  M. Genero, J.A. Cruz-Lemus, and  G. Tortora,  "On the Impact
of UML Analysis Models on Source-Code Comprehensibility and Modifiability", ACM Transactions on
Software Engineering and Methodlogy, vol. 23, no. 2, pp. 13:1-13:26, 2014
The family of experiments investigated whether the availability of analysis models in addition
to the source code made the code easier to understand and modify.
If you use this data set please cite:
[1] G.  G.  Scanniello,  C. Gravino,  M. Genero, J.A. Cruz-Lemus, and  G. Tortora, "On the
Impact of UML Analysis Models on Source-Code Comprehensibility and Modifiability", ACM
Transactions on Software Engineering and Methodology, vol. 23, no. 2, pp. 13:1-13:26, 2014
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM

}
\keyword{datasets}
