% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{CacheDBFile}
\alias{CacheDBFile}
\alias{CacheStorageDir}
\alias{CacheStoredFile}
\alias{CacheDBTableName}
\alias{CacheIsACache}
\title{A collection of low level tools for Cache}
\usage{
CacheDBFile(
  cachePath,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL)
)

CacheStorageDir(cachePath)

CacheStoredFile(
  cachePath,
  hash,
  format = getOption("reproducible.cacheSaveFormat", "rds")
)

CacheDBTableName(
  cachePath,
  drv = getOption("reproducible.drv", RSQLite::SQLite())
)

CacheIsACache(
  cachePath,
  create = FALSE,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL)
)
}
\arguments{
\item{cachePath}{A path describing the directory in which to create
the database file(s)}

\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{hash}{The cacheId or otherwise digested hash value, as character string.}

\item{format}{The text string representing the file extension used normally by
different save formats; currently only \code{"rds"} or \code{"qs"}. Defaults
to \code{getOption("reproducible.cacheSaveFormat", "rds")}}

\item{create}{Logical. Currently only affects non RQSLite default drivers. If this
is \code{TRUE} and there is no Cache database, the function will create one.}
}
\description{
These are not intended for normal use.
}
\details{
\code{CacheStoredFile} returns the file path to the file with the specified hash value.

\code{CacheStoredFile} returns the file path to the file with the specified hash value.

\code{CacheIsACache} returns a logical of whether the specified cachePath
  is actually a functioning cache.
}
