% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{createCache}
\alias{createCache}
\alias{saveToCache}
\alias{loadFromCache}
\alias{rmFromCache}
\title{Create a new cache}
\usage{
createCache(
  cachePath,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL),
  force = FALSE
)

saveToCache(
  cachePath,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL),
  obj,
  userTags,
  cacheId,
  linkToCacheId = NULL
)

loadFromCache(
  cachePath,
  cacheId,
  format = getOption("reproducible.cacheSaveFormat", "rds"),
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL)
)

rmFromCache(
  cachePath,
  cacheId,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL),
  format = getOption("reproducible.cacheSaveFormat", "rds")
)
}
\arguments{
\item{cachePath}{A path describing the directory in which to create
the database file(s)}

\item{drv}{A driver, passed to \code{dbConnect}}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{force}{Logical. Should it create a cache in the \code{cachePath},
even if it already exists, overwriting.}

\item{obj}{The R object to save to the cache}

\item{userTags}{A character vector with descriptions of the Cache function call. These
will be added to the Cache so that this entry in the Cache can be found using
\code{userTags} e.g., via \code{\link{showCache}}.}

\item{cacheId}{The hash string representing the result of \code{.robustDigest}}

\item{linkToCacheId}{Optional. If a \code{cacheId} is provided here, then a \code{file.link}
will be made to the file with that \code{cacheId} name in the cache repo.
This is used when identical outputs exist in the cache. This will save disk space.}

\item{format}{The text string representing the file extension used normally by
different save formats; currently only \code{"rds"} or \code{"qs"}. Defaults
to \code{getOption("reproducible.cacheSaveFormat", "rds")}}
}
\description{
Create a new cache

Low level tools to work with Cache
}
