% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{maskInputs}
\alias{maskInputs}
\alias{maskInputs.Raster}
\alias{maskInputs.Spatial}
\alias{maskInputs.sf}
\title{Mask module inputs}
\usage{
maskInputs(x, studyArea, ...)

\method{maskInputs}{Raster}(x, studyArea, rasterToMatch, maskWithRTM = FALSE, ...)

\method{maskInputs}{Spatial}(x, studyArea, ...)

\method{maskInputs}{sf}(x, studyArea, ...)
}
\arguments{
\item{x}{An object to do a geographic raster::mask/raster::intersect.
See methods.}

\item{studyArea}{\code{SpatialPolygons*} object used for masking and possibly cropping
if no \code{rasterToMatch} is provided.
If not in same CRS, then it will be \code{spTransform}ed to
CRS of \code{x} before masking. Currently, this function will not reproject the
\code{x}. Optional in \code{postProcess}.}

\item{...}{Passed to methods. None currently implemented.}

\item{rasterToMatch}{Template \code{Raster*} object used for cropping (so extent should be
the extent of desired outcome) and reprojecting (including changing the
resolution and projection).
See details in \code{\link{postProcess}}.}

\item{maskWithRTM}{Logical. If \code{TRUE}, then the default,}
}
\description{
This function can be used to mask inputs from data. Masking here is
equivalent to \code{raster::mask} (though \code{\link{fastMask}} is used here)
or \code{raster::intersect}.
}
\examples{
# Add a study area to Crop and Mask to
# Create a "study area"
library(sp)
library(raster)
ow <- setwd(tempdir())

# make a SpatialPolygon
coords1 <- structure(c(-123.98, -117.1, -80.2, -100, -123.98, 60.9, 67.73, 65.58, 51.79, 60.9),
                     .Dim = c(5L, 2L))
Sr1 <- Polygon(coords1)
Srs1 <- Polygons(list(Sr1), "s1")
shpEcozone <- SpatialPolygons(list(Srs1), 1L)
crs(shpEcozone) <- "+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"

# make a "study area" that is subset of larger dataset
coords <- structure(c(-118.98, -116.1, -99.2, -106, -118.98, 59.9, 65.73, 63.58, 54.79, 59.9),
                    .Dim = c(5L, 2L))
Sr1 <- Polygon(coords)
Srs1 <- Polygons(list(Sr1), "s1")
StudyArea <- SpatialPolygons(list(Srs1), 1L)
crs(StudyArea) <- "+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"
#'
#'
##########
shpEcozonePostProcessed <- postProcess(shpEcozone, studyArea = StudyArea)
#'
# Try manually, individual pieces
shpEcozoneReprojected <- projectInputs(shpEcozone, StudyArea)
shpEcozoneCropped <- cropInputs(shpEcozone, StudyArea)
shpEcozoneClean <- fixErrors(shpEcozone)
shpEcozoneMasked <- maskInputs(shpEcozone, StudyArea)

setwd(ow)
}
\author{
Eliot McIntire and Jean Marchal
}
