% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_blended.R
\name{fit_blended}
\alias{fit_blended}
\title{Fit a Blended mixture using an ECME-Algorithm}
\usage{
fit_blended(
  dist,
  obs,
  start,
  min_iter = 0L,
  max_iter = 100L,
  skip_first_e = FALSE,
  tolerance = 1e-05,
  trace = FALSE,
  ...
)
}
\arguments{
\item{dist}{A \code{BlendedDistribution}. It is assumed, that \code{breaks} and
\code{bandwidths} are not a placeholder and that \code{weights} are to be estimated.}

\item{obs}{Set of observations as produced by \code{\link[=trunc_obs]{trunc_obs()}} or convertible
via \code{\link[=as_trunc_obs]{as_trunc_obs()}}.}

\item{start}{Initial values of all placeholder parameters.
If missing, starting values are obtained from \code{\link[=fit_dist_start]{fit_dist_start()}}.}

\item{min_iter}{Minimum number of EM-Iterations}

\item{max_iter}{Maximum number of EM-Iterations (weight updates)}

\item{skip_first_e}{Skip the first E-Step (update Probability weights)?
This can help if the initial values cause a mixture component to vanish in
the first E-Step before the starting values can be improved.}

\item{tolerance}{Numerical tolerance.}

\item{trace}{Include tracing information in output?
If \code{TRUE}, additional tracing information will be added to the result list.}

\item{...}{Passed to \code{\link[=fit_dist_start]{fit_dist_start()}} if \code{start} is missing.}
}
\value{
A list with elements
\itemize{
\item \code{params} the fitted parameters in the same structure as \code{init}.
\item \code{params_hist} (if \code{trace} is TRUE) the history of parameters
(after each e- and m- step)
\item \code{iter} the number of outer EM-iterations
\item \code{logLik} the final log-likelihood
}
}
\description{
Fit a Blended mixture using an ECME-Algorithm
}
\examples{
dist <- dist_blended(
   list(
     dist_exponential(),
     dist_genpareto()
   )
 )

params <- list(
  probs = list(0.9, 0.1),
  dists = list(
    list(rate = 2.0),
    list(u = 1.5, xi = 0.2, sigmau = 1.0)
  ),
  breaks = list(1.5),
  bandwidths = list(0.3)
)

x <- dist$sample(100L, with_params = params)

dist$default_params$breaks <- params$breaks
dist$default_params$bandwidths <- params$bandwidths
if (interactive()) {
  fit_blended(dist, x)
}

}
\seealso{
Other distribution fitting functions: 
\code{\link{fit_dist}()},
\code{\link{fit_erlang_mixture}()},
\code{\link{fit_mixture}()}
}
\concept{distribution fitting functions}
