/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail;

import org.chocosolver.memory.IStorage;
import org.chocosolver.memory.trailing.EnvironmentTrailing;
import org.chocosolver.memory.trailing.StoredDoubleVector;

public class StoredDoubleVectorTrail
implements IStorage {
    private final EnvironmentTrailing environment;
    private final double loadfactor;
    private StoredDoubleVector[] vectorStack;
    private int[] indexStack;
    private double[] valueStack;
    private int[] stampStack;
    private int currentLevel;
    private int[] worldStartLevels;

    public StoredDoubleVectorTrail(EnvironmentTrailing env, int nUpdates, int nWorlds, double loadfactor) {
        this.environment = env;
        this.currentLevel = 0;
        this.vectorStack = new StoredDoubleVector[nUpdates];
        this.indexStack = new int[nUpdates];
        this.valueStack = new double[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
        this.loadfactor = loadfactor;
    }

    public void savePreviousState(StoredDoubleVector vect, int index, double oldValue, int oldStamp) {
        this.vectorStack[this.currentLevel] = vect;
        this.indexStack[this.currentLevel] = index;
        this.stampStack[this.currentLevel] = oldStamp;
        this.valueStack[this.currentLevel] = oldValue;
        ++this.currentLevel;
        if (this.currentLevel == this.vectorStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = (int)((double)this.vectorStack.length * this.loadfactor);
        StoredDoubleVector[] tmp1 = new StoredDoubleVector[newCapacity];
        System.arraycopy(this.vectorStack, 0, tmp1, 0, this.vectorStack.length);
        this.vectorStack = tmp1;
        double[] tmp2 = new double[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
        int[] tmp4 = new int[newCapacity];
        System.arraycopy(this.indexStack, 0, tmp4, 0, this.indexStack.length);
        this.indexStack = tmp4;
    }

    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
        if (worldIndex == this.worldStartLevels.length - 1) {
            this.resizeWorldCapacity((int)((double)this.worldStartLevels.length * this.loadfactor));
        }
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            StoredDoubleVector v = this.vectorStack[this.currentLevel];
            v._set(this.indexStack[this.currentLevel], this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        int startLevel = this.worldStartLevels[this.environment.getWorldIndex()];
        int prevWorld = this.environment.getWorldIndex() - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredDoubleVector var = this.vectorStack[level];
            int idx = this.indexStack[level];
            double val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.worldStamps[idx] = prevWorld;
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.indexStack[writeIdx] = idx;
                this.vectorStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }
}

