% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ethnicity.R
\name{predict_ethnicity}
\alias{predict_ethnicity}
\title{Predict ethnicity from names.}
\usage{
predict_ethnicity(
  firstnames = NULL,
  lastnames = NULL,
  method = "fullname",
  threads = 0,
  na.rm = FALSE
)
}
\arguments{
\item{firstnames}{A character vector of first names. Default to NULL. Only use this if you are using 'method' = 'fullname'.}

\item{lastnames}{A character vector of last names. Default to NULL. Use this in both 'fullname' and 'lastname' methods.}

\item{method}{"fullname" or "lastname". Inference method to choose from.}

\item{threads}{single integer. Number of threads to use for multi-threading.}

\item{na.rm}{TRUE or FALSE (boolean). If TRUE, then the NAs will be removed; if FALSE, then return error if there is NA in the arguments.}
}
\value{
data.frame with probability of being each ethnic group and the predicted group (one with highest probability)
}
\description{
Predict ethnicity from names.
}
\examples{
predict_ethnicity(firstnames = "Alan", lastnames = "Turing")

}
