% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriangulatedOutline.R
\name{TriangulatedOutline}
\alias{TriangulatedOutline}
\title{Class containing functions and data relating to Triangulation}
\description{
A TriangulatedOutline contains a function to create a
  triangulated mesh over an outline, and fields to hold the mesh
  information. Note that areas and lengths are all scaled using
  the value of the \code{scale} field.
}
\examples{
P <- rbind(c(1,1),   c(2,1),  c(2,-1),
           c(1,-1),  c(1,-2), c(-1,-2),
           c(-1,-1), c(-2,-1),c(-2,1),
           c(-1,1),  c(-1,2), c(1,2))
o <- TriangulatedOutline$new(P)
o$addTear(c(3, 4, 5))
o$addTear(c(6, 7, 8))
o$addTear(c(9, 10, 11))
o$addTear(c(12, 1, 2))
flatplot(o)
}
\author{
David Sterratt
}
\section{Super classes}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{\link[retistruct:Outline]{retistruct::Outline}} -> \code{\link[retistruct:PathOutline]{retistruct::PathOutline}} -> \code{\link[retistruct:AnnotatedOutline]{retistruct::AnnotatedOutline}} -> \code{TriangulatedOutline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{T}}{3 column matrix in which each row contains IDs of
points of each triangle}

\item{\code{A}}{Area of each triangle in the mesh - has same number of
elements as there are rows of \code{T}}

\item{\code{A.tot}}{Total area of the mesh}

\item{\code{Cu}}{2 column matrix in which each row contains IDs of}

\item{\code{L}}{Length of each edge in the mesh - has same number of
elements as there are rows of \code{Cu}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-triangulate}{\code{TriangulatedOutline$triangulate()}}
\item \href{#method-mapTriangulatedFragment}{\code{TriangulatedOutline$mapTriangulatedFragment()}}
\item \href{#method-clone}{\code{TriangulatedOutline$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-clearFeatureSets}{\code{retistruct::OutlineCommon$clearFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSet">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSet}{\code{retistruct::OutlineCommon$getFeatureSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSets}{\code{retistruct::OutlineCommon$getFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSetTypes}{\code{retistruct::OutlineCommon$getFeatureSetTypes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs">}\href{../../retistruct/html/OutlineCommon.html#method-getIDs}{\code{retistruct::OutlineCommon$getIDs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="addFeatureSet">}\href{../../retistruct/html/Outline.html#method-addFeatureSet}{\code{retistruct::Outline$addFeatureSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getImage">}\href{../../retistruct/html/Outline.html#method-getImage}{\code{retistruct::Outline$getImage()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineLengths">}\href{../../retistruct/html/Outline.html#method-getOutlineLengths}{\code{retistruct::Outline$getOutlineLengths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineSet">}\href{../../retistruct/html/Outline.html#method-getOutlineSet}{\code{retistruct::Outline$getOutlineSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPoints">}\href{../../retistruct/html/Outline.html#method-getPoints}{\code{retistruct::Outline$getPoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPointsScaled">}\href{../../retistruct/html/Outline.html#method-getPointsScaled}{\code{retistruct::Outline$getPointsScaled()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapFragment">}\href{../../retistruct/html/Outline.html#method-mapFragment}{\code{retistruct::Outline$mapFragment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapPids">}\href{../../retistruct/html/Outline.html#method-mapPids}{\code{retistruct::Outline$mapPids()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="replaceImage">}\href{../../retistruct/html/Outline.html#method-replaceImage}{\code{retistruct::Outline$replaceImage()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="addPoints">}\href{../../retistruct/html/PathOutline.html#method-addPoints}{\code{retistruct::PathOutline$addPoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="insertPoint">}\href{../../retistruct/html/PathOutline.html#method-insertPoint}{\code{retistruct::PathOutline$insertPoint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="nextPoint">}\href{../../retistruct/html/PathOutline.html#method-nextPoint}{\code{retistruct::PathOutline$nextPoint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="stitchSubpaths">}\href{../../retistruct/html/PathOutline.html#method-stitchSubpaths}{\code{retistruct::PathOutline$stitchSubpaths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="addTear">}\href{../../retistruct/html/AnnotatedOutline.html#method-addTear}{\code{retistruct::AnnotatedOutline$addTear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="checkTears">}\href{../../retistruct/html/AnnotatedOutline.html#method-checkTears}{\code{retistruct::AnnotatedOutline$checkTears()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="computeTearRelationships">}\href{../../retistruct/html/AnnotatedOutline.html#method-computeTearRelationships}{\code{retistruct::AnnotatedOutline$computeTearRelationships()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="ensureFixedPointInRim">}\href{../../retistruct/html/AnnotatedOutline.html#method-ensureFixedPointInRim}{\code{retistruct::AnnotatedOutline$ensureFixedPointInRim()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="getFixedPoint">}\href{../../retistruct/html/AnnotatedOutline.html#method-getFixedPoint}{\code{retistruct::AnnotatedOutline$getFixedPoint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="getRimLengths">}\href{../../retistruct/html/AnnotatedOutline.html#method-getRimLengths}{\code{retistruct::AnnotatedOutline$getRimLengths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="getRimSet">}\href{../../retistruct/html/AnnotatedOutline.html#method-getRimSet}{\code{retistruct::AnnotatedOutline$getRimSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="getTear">}\href{../../retistruct/html/AnnotatedOutline.html#method-getTear}{\code{retistruct::AnnotatedOutline$getTear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="getTears">}\href{../../retistruct/html/AnnotatedOutline.html#method-getTears}{\code{retistruct::AnnotatedOutline$getTears()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="initialize">}\href{../../retistruct/html/AnnotatedOutline.html#method-initialize}{\code{retistruct::AnnotatedOutline$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="labelTearPoints">}\href{../../retistruct/html/AnnotatedOutline.html#method-labelTearPoints}{\code{retistruct::AnnotatedOutline$labelTearPoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="removeTear">}\href{../../retistruct/html/AnnotatedOutline.html#method-removeTear}{\code{retistruct::AnnotatedOutline$removeTear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="setFixedPoint">}\href{../../retistruct/html/AnnotatedOutline.html#method-setFixedPoint}{\code{retistruct::AnnotatedOutline$setFixedPoint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="AnnotatedOutline" data-id="whichTear">}\href{../../retistruct/html/AnnotatedOutline.html#method-whichTear}{\code{retistruct::AnnotatedOutline$whichTear()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-triangulate"></a>}}
\if{latex}{\out{\hypertarget{method-triangulate}{}}}
\subsection{Method \code{triangulate()}}{
Triangulate (mesh) outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TriangulatedOutline$triangulate(n = 200, suppress.external.steiner = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Desired number of points in mesh}

\item{\code{suppress.external.steiner}}{Boolean variable describing
whether to insert external Steiner points - see
\link{TriangulatedFragment}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mapTriangulatedFragment"></a>}}
\if{latex}{\out{\hypertarget{method-mapTriangulatedFragment}{}}}
\subsection{Method \code{mapTriangulatedFragment()}}{
Map the point IDs of a \link{TriangulatedFragment} on the
  point IDs of this Outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TriangulatedOutline$mapTriangulatedFragment(fragment, pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fragment}}{\link{TriangulatedFragment} to map}

\item{\code{pids}}{Point IDs in TriangulatedOutline of points in \link{TriangulatedFragment}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TriangulatedOutline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
