% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheristruct.R
\name{Ecart}
\alias{Ecart}
\title{The deformation energy function}
\usage{
Ecart(P, Cu, L, Tr, A, R, alpha = 1, x0, nu = 1, verbose = FALSE)
}
\arguments{
\item{P}{N-by-3 matrix of point coordinates}

\item{Cu}{The upper part of the connectivity matrix}

\item{L}{Length of each edge in the flattened outline}

\item{Tr}{Triangulation in the flattened outline}

\item{A}{Area of each triangle in the flattened outline}

\item{R}{Radius of sphere}

\item{alpha}{Area penalty scaling coefficient}

\item{x0}{Area penalty cut-off coefficient}

\item{nu}{Power to which to raise area}

\item{verbose}{How much information to report}
}
\value{
A single value, representing the energy of this particular
configuration
}
\description{
The function that computes the energy (or error) of the
deformation of the mesh from the flat outline to the sphere. This
depends on the locations of the points given in spherical
coordinates. The function is designed to take these as a vector
that is received from the \code{optim} function.
}
\author{
David Sterratt
}
