% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_val_labels.R
\name{collect_val_labels}
\alias{collect_val_labels}
\alias{collect_na_labels}
\title{Collect labels from metadata file}
\usage{
collect_val_labels(metadata)

collect_na_labels(metadata)
}
\arguments{
\item{metadata}{A metadata data frame created by 
\code{\link{metadata_create}}.}
}
\value{
The unique valid labels or the user-defined missing 
labels found in all the files analyzed in \code{metadata}.
}
\description{
Collect labels from metadata file
}
\examples{
test_survey <- retroharmonize::read_rds (
   file = system.file("examples", "ZA7576.rds",
                  package = "retroharmonize"), 
   id = "test"
)
example_metadata <- metadata_create (test_survey)

collect_val_labels (metadata = example_metadata )
collect_na_labels ( metadata = example_metadata )
}
\seealso{
Other harmonization functions: 
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_values}()},
\code{\link{harmonize_var_names}()},
\code{\link{harmonize_waves}()},
\code{\link{label_normalize}()},
\code{\link{merge_waves}()},
\code{\link{na_range_to_values}()},
\code{\link{suggest_permanent_names}()},
\code{\link{suggest_var_names}()}
}
\concept{harmonization functions}
