% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_var_names.R
\name{harmonize_var_names}
\alias{harmonize_var_names}
\title{Harmonize the variable names of surveys}
\usage{
harmonize_var_names(
  waves,
  metadata,
  old = "var_name_orig",
  new = "var_name_suggested",
  rowids = TRUE
)
}
\arguments{
\item{waves}{A list of surveys imported with \code{\link{read_surveys}}.}

\item{metadata}{A metadata table created by \code{metadata_create} and binded together for 
all surveys in \code{waves}.}

\item{old}{The column name in \code{metadata} that contains the old, not harmonized variable names.}

\item{new}{The column name in \code{metadata} that contains the new, harmonized variable names.}

\item{rowids}{Rename var labels of original vars \code{rowid} to simply \code{uniqid}?}
}
\value{
The list of surveys with harmonized variable names.
}
\description{
The function harmonizes the variable names of surveys (of class \code{survey}) that 
are imported from an external file as a wave.
}
\details{
If the \code{metadata} that contains subsetting information is subsetted, then 
it will subset the surveys in 
\code{waves}.
}
\examples{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_list <- dir(examples_dir)[grepl("\\\\.rds", dir(examples_dir))]

example_surveys <- read_surveys(
  file.path( examples_dir, survey_list), 
  save_to_rds = FALSE)
metadata <- lapply ( X = example_surveys, FUN = metadata_create )
metadata <- do.call(rbind, metadata)

metadata$var_name_suggested <- label_normalize(metadata$var_name)

metadata$var_name_suggested[metadata$label_orig == "age education"] <- "age_education"

harmonize_var_names(waves = example_surveys, 
                    metadata = metadata )
}
\seealso{
Other harmonization functions: 
\code{\link{collect_val_labels}()},
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_values}()},
\code{\link{harmonize_waves}()},
\code{\link{label_normalize}()},
\code{\link{merge_waves}()},
\code{\link{na_range_to_values}()},
\code{\link{suggest_permanent_names}()},
\code{\link{suggest_var_names}()}
}
\concept{harmonization functions}
