% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_facts.R
\name{get_facts_versions}
\alias{get_facts_versions}
\title{List supported FACTS versions}
\usage{
get_facts_versions()
}
\value{
A character vector of supported FACTS versions.
}
\description{
List versions of FACTS supported by \code{rfacts}.
You can supply any of these versions to functions engine-specific
functions such as \code{\link[=run_engine_contin]{run_engine_contin()}}.
}
\details{
If your FACTS file does not perfectly agree
with one of the supported versions, \code{rfacts} will try to find
the best version for you, either
\enumerate{
\item The greatest supported version less than or equal to the
one in the FACTS file, or
\item The lowest supported version if (1) does not exist.
}
}
\examples{
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
get_facts_versions()
}
}
\seealso{
\code{\link[=get_facts_version]{get_facts_version()}}, \code{\link[=run_engine_contin]{run_engine_contin()}}
}
