% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_flfll.R
\name{run_flfll}
\alias{run_flfll}
\title{Generate param files to prepare for trial simulations}
\usage{
run_flfll(
  facts_file,
  output_path = tempfile(),
  log_path = output_path,
  n_burn = NULL,
  n_mcmc = NULL,
  n_weeks_files = 10000,
  n_patients_files = 10000,
  n_mcmc_files = 0,
  n_mcmc_thin = NULL,
  flfll_seed = NULL,
  flfll_offset = NULL,
  verbose = FALSE,
  max_sims = 99999L
)
}
\arguments{
\item{facts_file}{Character, name of a FACTS file.
Usually has a \verb{*.facts} file extension.}

\item{output_path}{Character, directory path to the files to generate.}

\item{log_path}{Character, path to the log file generated by FLFLL.}

\item{n_burn}{Number of burn-in iterations for the MCMC.}

\item{n_mcmc}{Number of MCMC iterations used in inference.}

\item{n_weeks_files}{Number of \code{weeks*.csv} files to save in \code{output_path}.}

\item{n_patients_files}{Number of \code{patients*.csv} files to save in
\code{output_path}.}

\item{n_mcmc_files}{Number of \code{mcmc*.csv} files to save in
\code{output_path}.}

\item{n_mcmc_thin}{Number of thinning iterations for the MCMC.}

\item{flfll_seed}{Positive integer, random number generator seed for FLFLL.
This seed is only used for stochastic preprocessing steps for generating
the \verb{*.param} files. It is not the random number generator seed
for the actual trial simulations. To set the trial simulation seed,
use the \code{seed} argument of \code{\link[=run_facts]{run_facts()}}, \code{\link[=run_engine]{run_engine()}}, or
one of the specific \verb{run_engine*()} functions.}

\item{flfll_offset}{Integer, offset for the random number generator.}

\item{verbose}{Logical, whether to print progress information to the
R console.}

\item{max_sims}{Positive integer of length 1, maximum number of simulations
that will be allowed to run for certain engines like CRM
in subsequent calls to the engine. If the \code{n_sims} argument
of the engine is larger than \code{max_sims}, only \code{max_sims}
simulations will be run. The \code{max_sims} argument
only applies to FLFLL >= 6.4.1
and only needs to be set manually if you are manually calling
\code{run_flfll()} and then the engine instead of just \code{\link[=run_facts]{run_facts()}}.}
}
\value{
Character, the value of \code{output_path}.
\code{output_path} is the directory path to the files generated by
\code{run_flfll()}.
}
\description{
Generate the preparatory files required for simulation.
}
\details{
For advanced control over trial simulations, you must first call
\code{\link[=run_flfll]{run_flfll()}} and then call one of the engine functions
such as \code{\link[=run_engine_contin]{run_engine_contin()}}.
\code{\link[=run_flfll]{run_flfll()}} generates the preparatory \verb{*.param} files that the
\verb{run_engine_*()} functions understand.
You will pass these \verb{*.param} files or their parent
directory to \code{param_files} argument of \code{\link[=run_engine_contin]{run_engine_contin()}} etc.
}
\examples{
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
facts_file <- get_facts_file_example("contin.facts") # example FACTS file
out <- run_flfll(facts_file, verbose = FALSE) # Generate param files.
# Run the simulations.
run_engine(
  facts_file,
  param_files = out,
  n_sims = 1,
  verbose = FALSE
)
read_patients(out)
}
}
\seealso{
\code{\link[=get_facts_file_example]{get_facts_file_example()}}, \code{\link[=run_engine]{run_engine()}}, \code{\link[=run_engine_contin]{run_engine_contin()}}
}
