% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{gd_install}
\alias{gd_install}
\title{Install Required Python Modules}
\usage{
gd_install(pip = TRUE, system = FALSE, force = TRUE, ...)
}
\arguments{
\item{pip}{Use \code{pip} package manager? Default: \code{TRUE}}

\item{system}{Use a \code{system()} call to \verb{python -m pip install ...} instead of \code{reticulate::py_install()}. Default: \code{FALSE}.}

\item{force}{Force update (uninstall/reinstall) and ignore existing installed packages? Default: \code{TRUE}. Applies only to \code{pip=TRUE}.}

\item{...}{Additional arguments passed to \code{reticulate::py_install()}}
}
\value{
\code{NULL}, or \code{try-error} (invisibly) on R code execution error.
}
\description{
This function installs the latest \code{numpy}, \code{earthengine-api}, and
\code{geedim} modules. The default uses \code{pip} for package installation. You can
configure custom environments with \code{pip=FALSE} and additional arguments
that are passed to \code{reticulate::py_install()}.
}
\examples{
\dontrun{

# install with pip
gd_install()

# install with pip

# use virtual environment with default name "r-reticulate"
gd_install(pip = FALSE, method = "virtualenv")

# use "conda" environment named "foo"
gd_install(pip = FALSE, method = "conda", envname = "foo")

}
}
